package gov.va.genisis2.bo;

import static org.junit.Assert.assertNotNull;

import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.util.Helper;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

/**
 * The Class BusinessHelperTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class BusinessHelperTest.
 * 
 *         Description: In this BusinessHelperTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class BusinessHelperTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(BusinessHelperTest.class);

	private BusinessHelper businessHelper;
	
	private ResponseWrapper wrapper;

	@Test
	public void validateCopyTableSource() {

		CopyTableSource copyTableSource = Helper.getCopyTableSource();
		wrapper = new ResponseWrapper();
		businessHelper = new BusinessHelper();
		assertNotNull(businessHelper.validateCopyTableSource(copyTableSource, copyTableSource, wrapper));
	}

	@Test
	public void validateCopyTableSourceNull() {

		CopyTableSource copyTableSourceNull = new CopyTableSource();
		wrapper = new ResponseWrapper();
		businessHelper = new BusinessHelper();
		assertNotNull(businessHelper.validateCopyTableSource(copyTableSourceNull, copyTableSourceNull, wrapper));
	}

}
